clear all

* Set Folder to input one

cd ..\Inputs

********************************************************************************
* Import and clean unemployment

import excel "Vintages of unemployment.xlsx", ///
sheet(ruc) cellrange(A1) firstrow clear

quiet foreach v of varlist RUC* {
	destring `v', replace force
}

drop if DATE==""

gen year=substr(DATE,1,4)
destring year, replace force
gen month=substr(DATE,6,2)
destring month, replace force

gen     quarter=1 if month==1 | month==2 | month==3
replace quarter=2 if month==4 | month==5 | month==6
replace quarter=3 if month==7 | month==8 | month==9
replace quarter=4 if month==10 | month==11 | month==12

save temp, replace

collapse (mean) RUC*, by(year quarter)
save temp2, replace

use temp, clear
collapse (count) RUC*, by(year quarter)

rename RUC* count*
save temp3, replace

use temp2, clear
joinby year quarter using temp3

quiet foreach var of varlist RUC* {
	local str0=substr("`var'",4,4)
	replace `var'=. if count`str0'~=3
}
	
sort year quarter 
gen t=_n
drop count*	
order t year quarter 

save vin_unra, replace

********************************************************************************
* Import and clean aggregate weekly hours

import excel "Vintages of aggregate weekly hours.xlsx", ///
sheet(h) cellrange(A1) firstrow clear

quiet foreach v of varlist H* {
	destring `v', replace force
}

drop if DATE==""

gen year=substr(DATE,1,4)
destring year, replace force
gen month=substr(DATE,6,2)
destring month, replace force

gen     quarter=1 if month==1  | month==2  | month==3
replace quarter=2 if month==4  | month==5  | month==6
replace quarter=3 if month==7  | month==8  | month==9
replace quarter=4 if month==10 | month==11 | month==12

save temp, replace

collapse (mean) H*, by(year quarter)
save temp2, replace

use temp, clear
collapse (count) H*, by(year quarter)

rename H* count*
save temp3, replace

use temp2, clear
joinby year quarter using temp3

quiet foreach var of varlist H* {
	local str0=substr("`var'",2,5)
	replace `var'=. if count`str0'~=3
}
	
sort year quarter 
drop count*	
order year quarter
drop if year<1964

forvalues i=71(1)117 {
	local j=string(mod(`i',100),"%02.0f")
	forvalues q=1(1)4 {
		capture egen H`j'Q`q'=rowmean(H`j'M`=(`q'-1)*3+1'  H`j'M`=(`q'-1)*3+2'  H`j'M`=(`q'-1)*3+3')
	}
}

drop H*M*

save vin_hour, replace

********************************************************************************
* Import and clean nonfarm payroll employment

import excel "Vintages of nonfarm payroll employment.xlsx", ///
sheet(employ) cellrange(A1) firstrow clear

quiet foreach v of varlist EMPLOY* {
	destring `v', replace force
}

drop if DATE==""

gen year=substr(DATE,1,4)
destring year, replace force
gen month=substr(DATE,6,2)
destring month, replace force

gen     quarter=1 if month==1  | month==2  | month==3
replace quarter=2 if month==4  | month==5  | month==6
replace quarter=3 if month==7  | month==8  | month==9
replace quarter=4 if month==10 | month==11 | month==12

save temp, replace

collapse (mean) EMPLOY*, by(year quarter)
save temp2, replace

use temp, clear
collapse (count) EMPLOY*, by(year quarter)

rename EMPLOY* count*
save temp3, replace

use temp2, clear
joinby year quarter using temp3

quiet foreach var of varlist EMPLOY* {
	local str0=substr("`var'",7,5)
	replace `var'=. if count`str0'~=3
}
	
sort year quarter 
drop count*	
order year quarter
drop if year<1947

forvalues i=64(1)117 {
	local j=string(mod(`i',100),"%02.0f")
	forvalues q=1(1)4 {
		capture egen EMPLOY`j'Q`q'=rowmean(EMPLOY`j'M`=(`q'-1)*3+1'  EMPLOY`j'M`=(`q'-1)*3+2'  EMPLOY`j'M`=(`q'-1)*3+3')
	}
}

drop EMPLOY*M*

save vin_empl, replace

********************************************************************************
* Import and clean GDP deflator

import excel "Vintages of GDP deflator.xlsx", ///
sheet(P) cellrange(A1) firstrow clear

foreach v of varlist P* {
	destring `v', replace force
}

drop if DATE==""

gen t=_n

gen year=substr(DATE,1,4)
destring year, replace force
gen quarter=substr(DATE,7,1)
destring quarter, replace force
drop DATE

order t year quarter
tsset t

foreach v of varlist P* {
	local dumb: var label `v'
	local str0=substr("`dumb'",2,4)
	gen INFLAT`str0'=D.`v'/L.`v'*400
}

drop t

save vin_pric, replace

********************************************************************************
* Import and clean Real Consumption Expenditure

import excel "Vintages of Real CON.xlsx", ///
sheet(RCON) cellrange(A1) firstrow clear

foreach v of varlist RCON* {
	destring `v', replace force
}

drop if DATE==""

gen t=_n

gen year=substr(DATE,1,4)
destring year, replace force
gen quarter=substr(DATE,7,1)
destring quarter, replace force
drop DATE

order t year quarter
tsset t

foreach v of varlist RCON* {
	local dumb: var label `v'
	local str0=substr("`dumb'",5,4)
	gen GRCON`str0'=D.`v'/L.`v'*400
}

drop t

save vin_rcon, replace

********************************************************************************
* Import and clean Real Non-durable Consumption

import excel "Vintages of non durable CON.xlsx", ///
sheet(RCONND) cellrange(A1) firstrow clear

foreach v of varlist RCONND* {
	destring `v', replace force
}

drop if DATE==""
gen t=_n
gen year=substr(DATE,1,4)
destring year, replace force
gen quarter=substr(DATE,7,1)
destring quarter, replace force
drop DATE
order t year quarter
tsset t

foreach v of varlist RCONND* {
	local dumb: var label `v'
	local str0=substr("`dumb'",7,4)
	gen GRCONND`str0'=D.`v'/L.`v'*400
}

drop t

save vin_rconnd, replace

********************************************************************************
* Import and clean Real Durable Consumption

import excel "Vintages of durable CON.xlsx", ///
sheet(RCOND) cellrange(A1) firstrow clear

foreach v of varlist RCOND* {
	destring `v', replace force
}

drop if DATE==""
gen t=_n
gen year=substr(DATE,1,4)
destring year, replace force
gen quarter=substr(DATE,7,1)
destring quarter, replace force
drop DATE
order t year quarter
tsset t

foreach v of varlist RCOND* {
	local dumb: var label `v'
	local str0=substr("`dumb'",6,4)
	gen GRCOND`str0'=D.`v'/L.`v'*400
}

drop t

save vin_rcond, replace

********************************************************************************
* Import and clean Service Consumption

import excel "Vintages of service CON.xlsx", ///
sheet(RCONS) cellrange(A1) firstrow clear

foreach v of varlist RCONS* {
	destring `v', replace force
}

drop if DATE==""
gen t=_n
gen year=substr(DATE,1,4)
destring year, replace force
gen quarter=substr(DATE,7,1)
destring quarter, replace force
drop DATE
order t year quarter
tsset t

foreach v of varlist RCONS* {
	local dumb: var label `v'
	local str0=substr("`dumb'",6,4)
	gen GRCONS`str0'=D.`v'/L.`v'*400
}

drop t

save vin_rcons, replace

********************************************************************************
* Import Output Gap Information from Orphanides and Greenbook

* Import Output Gap from Orhanides first

import excel "Real Time Output Gap (Orphanides).xlsx", ///
sheet(FINAL DATA | FOMC frequency) cellrange(A2) firstrow clear

rename Year year
rename Quarter quarter
rename N FINGtAt

keep year quarter FINGtAt

label var FINGtAt   "Final, Output gap at time t as available at time t"
drop if FINGtAt==.
collapse (first) FINGtAt, by(year quarter)

save gaporp, replace

* Import Output Gap from Greenbook

import excel "Greenbook Output Gap.xls", ///
sheet(Output Gap) cellrange(A3) firstrow clear

gen year=substr(C,1,4)
gen quarter=substr(C,6,1)

destring year quarter, replace

label var L "Output gap in the current period"
rename L gapf0

keep year quarter gapf0
collapse (first) gapf0, by(year quarter)

joinby year quarter using gaporp, unmatched(both)
drop _merge

replace gapf0=FINGtAt if gapf0==.
drop FINGtAt

save gapgresimple, replace

********************************************************************************
* Import inflation expectations data from MSC

import excel "MSCinflationexpectations.xls", ///
sheet(REDBK32) cellrange(A10) firstrow clear
drop if B==.

rename B year

gen month=.
replace month=1 if  DateofSurvey=="January"
replace month=2 if  DateofSurvey=="February"
replace month=3 if  DateofSurvey=="March"
replace month=4 if  DateofSurvey=="April"
replace month=5 if  DateofSurvey=="May"
replace month=6 if  DateofSurvey=="June"
replace month=7 if  DateofSurvey=="July"
replace month=8 if  DateofSurvey=="August"
replace month=9 if  DateofSurvey=="September"
replace month=10 if DateofSurvey=="October"
replace month=11 if DateofSurvey=="November"
replace month=12 if DateofSurvey=="December"

gen quarter=.
replace quarter=1 if  month<4
replace quarter=2 if  month==4 | month==5 | month==6
replace quarter=3 if  month==7 | month==8 | month==9
replace quarter=4 if  month>9

rename Mean MSCinfexp
destring MSCinfexp, replace force
drop if MSCinfexp==.

keep year quarter month MSCinfexp
collapse (mean) MSCinfexp, by(year quarter)

gen qa1948=(year-1948)*4+quarter
tsset qa1948
tsfill
gen quarterfake=mod(qa1948,4)
replace quarterfake=4 if quarterfake==0
gen yearfake=(qa1948-quarterfake)/4+1948

ipolate MSCinfexp qa1948, gen(MSCinfexpipo)

keep quarterfake yearfake MSCinfexpipo

rename yearfake year
rename quarterfake quarter
rename MSCinfexpipo MSCinfexp

save mscie, replace

********************************************************************************
* Import FRED change in oil price

import excel "FREDoilprice.xls", ///
sheet(FRED Graph) cellrange(A11) firstrow clear

rename WTISPLC_PC1 oilprice

gen year=year(observation_date)
gen quarter=quarter(observation_date)
drop observation_date

save fredoil, replace

********************************************************************************
* Import FRED last vintage of output gap

import excel "FREDgap.xls", ///
sheet(FRED Graph) cellrange(A12) firstrow clear

rename GDPPOT potout
rename GDPC96 actout
gen gaplv=(actout-potout)/potout*100

gen year=year(observation_date)
gen quarter=quarter(observation_date)
drop observation_date

save fredgap, replace

********************************************************************************
* Import FRED last vintage of natural rate of unemployment

import excel "FREDnru.xls", ///
sheet(FRED Graph) cellrange(A12) firstrow clear

rename NROU nrulv
rename NROUST nrustlv

gen year=year(observation_date)
gen quarter=quarter(observation_date)
drop observation_date

save frednru, replace

********************************************************************************
* Merge these databases together and with real gdp growth

use vin_unra, clear

joinby year quarter using vin_hour, unmatched(both)
drop _merge
joinby year quarter using vin_empl, unmatched(both)
drop _merge
joinby year quarter using vin_pric, unmatched(both)
drop _merge
joinby year quarter using vin_rcon, unmatched(both)
drop _merge
joinby year quarter using vin_rconnd, unmatched(both)
drop _merge
joinby year quarter using vin_rcond, unmatched(both)
drop _merge
joinby year quarter using vin_rcons, unmatched(both)
drop _merge
joinby year quarter using gapgresimple, unmatched(both)
drop _merge
joinby year quarter using mscie, unmatched(both)
drop _merge
joinby year quarter using fredoil, unmatched(both)
drop _merge
joinby year quarter using fredgap, unmatched(both)
drop _merge
joinby year quarter using frednru, unmatched(both)
drop _merge
joinby year quarter using vin_rgdp, unmatched(both)
drop _merge DATE

tsset t

* Generate consumption in durables plus services and its growth

foreach v of varlist RCONND* {
	local dumb: var label `v'
	local str0=substr("`dumb'",7,4)
	gen RCONNDS`str0'=RCONND`str0'+RCONS`str0'
}

foreach v of varlist RCONNDS* {
	gen G`v'=D.`v'/L.`v'*400
}

* Generate inflation and unemployment in real time

gen inflatrt=.
gen uert=.
forvalues tt=76(1)281 { 
	local yearloc=year[`tt']
	local yearstr=string(`yearloc')
	local ylt=substr("`yearstr'",3,2)
	local quarter=quarter[`tt']
	sum t if !mi(INFLAT`ylt'Q`quarter'), meanonly
	local last = r(max)
	replace inflatrt=INFLAT`ylt'Q`quarter' if t==`last'
	sum t if !mi(RUC`ylt'Q`quarter'), meanonly
	local last = r(max)
	replace uert=RUC`ylt'Q`quarter' if t==`last'
}

erase temp.dta
erase temp2.dta
erase temp3.dta
erase vin_unra.dta
erase vin_hour.dta
erase vin_empl.dta
erase vin_pric.dta
erase vin_rcon.dta
erase vin_rconnd.dta
erase vin_rcond.dta
erase vin_rcons.dta
erase gapgresimple.dta
erase mscie.dta
erase fredoil.dta
erase fredgap.dta
erase frednru.dta
erase gaporp.dta
erase vin_rgdp.dta
erase Greenbook_GAP.dta
erase Greenbook_gRGDP.dta

* Chnage to output folder and save

cd ..\Outputs
save vin_all, replace

********************************************************************************
* Run Phillips curve regressions and estimations

tsset t
gen time=year+(quarter-1)/4

* Predict the output gap using the Phillips curve and then smooth

reg INFLAT17Q1 MSCinfexp gaplv
gen gappred=(INFLAT17Q1-_b[MSCinfexp]*MSCinfexp)/_b[gaplv]
tssmooth ma gappreds=gappred, window(4 1 0)

* Generate potential from the gap information

foreach var in gappred gappreds gaplv {
	gen pot`var'=ROUTPUT17Q1/(1+`var'/100)
}

* Generate growth in potential

foreach v of varlist potgappred potgappreds potgaplv {
	gen G`v'=(`v'-L.`v')/L.`v'*400
}

* Accumulate growth in potential and actual starting from 2000

local baseindex = 2000
local counter=1
foreach var of varlist Gpotgappred Gpotgappreds Gpotgaplv GROUTPUT17Q1 {
	gen sap`counter'=.
	replace sap`counter'=0 if time==`baseindex'
	replace sap`counter'=sap`counter'[_n-1]+`var'/400 if sap`counter'==. & time>`baseindex'
	local ++counter
}

* Normalize to equal zero in 2007

local base      = 2007
summ t if time==`base'
local obsofbase = r(mean)
ds sap*

foreach var of varlist `r(varlist)' {
	gen `var'base=`var'[`obsofbase']
	replace `var'=`var'-`var'base
	drop `var'base
}

* Rename, keep important variables and save

rename sap1 fig14PCU1
rename sap2 fig14PCU2
rename sap3 fig14CBO
rename sap4 fig14ACT

keep t year quarter time fig14PCU* fig14CBO fig14ACT

save fig14PCU, replace
